/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;

public class ReplacedEnderman
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (!state.isMoving()) {
                state.getController().setAnimation(enderman.m_32531_() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "creepy_controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (!enderman.m_32531_()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "hold_controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (enderman.m_32530_() == null) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        }));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_controller", 0.0f, state -> {
            EnderMan enderman = this.getEndermanFromState((AnimationEvent<ReplacedEnderman>)state);
            if (enderman == null) {
                return PlayState.STOP;
            }
            if (enderman.m_21324_(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        }));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    public EnderMan getEndermanFromState(AnimationEvent<ReplacedEnderman> state) {
        List list = state.getExtraDataOfType(LivingEntity.class);
        if (list.isEmpty()) {
            return null;
        }
        Entity entity = (Entity)list.get(0);
        if (!(entity instanceof EnderMan)) {
            return null;
        }
        EnderMan enderman = (EnderMan)entity;
        return enderman;
    }
}

